---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：2-Startup Performance Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **目標出力時間**：明示的な定義なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/performance/browser/perfviewEditor.ts` - PerfviewContrib (行35-64)
- E-02: `src/vs/workbench/contrib/performance/browser/perfviewEditor.ts` - PerfviewInput (行66-100)
- E-03: `src/vs/workbench/contrib/performance/browser/perfviewEditor.ts` - PerfModelContentProvider (行102-320)
- E-04: `src/vs/workbench/contrib/performance/browser/perfviewEditor.ts` - _addSummary() (行169-188)
- E-05: `src/vs/workbench/contrib/performance/browser/perfviewEditor.ts` - _addSummaryTable() (行190-227)
- E-06: `src/vs/workbench/contrib/performance/browser/perfviewEditor.ts` - _addExtensionsTable() (行229-254)
- E-07: `src/vs/workbench/contrib/performance/browser/perfviewEditor.ts` - _addPerfMarksTable() (行256-273)
- E-08: `src/vs/workbench/contrib/performance/browser/perfviewEditor.ts` - _addWorkbenchContributionsPerfMarksTable() (行275-290)
- E-09: `src/vs/workbench/contrib/performance/browser/perfviewEditor.ts` - _addRawPerfMarks() (行292-308)
- E-10: `src/vs/workbench/contrib/performance/browser/perfviewEditor.ts` - _addResourceTimingStats() (行310-319)
- E-11: `src/vs/workbench/contrib/performance/browser/perfviewEditor.ts` - MarkdownBuilder (行322-380)
- E-12: `src/vs/workbench/contrib/performance/browser/perfviewEditor.ts` - _updateModel() (行137-166)
- E-13: `src/vs/workbench/contrib/performance/browser/perfviewEditor.ts` - provideTextContent() (行119-135)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URI schemeは'perf' | E-01 (行43) | ○ |
| C-02 | タイトルは'Startup Performance' | E-02 (行86) | ○ |
| C-03 | 言語モードはMarkdown | E-03 (行123) | ○ |
| C-04 | Word WrapはOff | E-03 (行131) | ○ |
| C-05 | System InfoにProduct Name/Versionが含まれる | E-04 (行172) | ○ |
| C-06 | System InfoにOS情報が含まれる | E-04 (行173) | ○ |
| C-07 | System InfoにCPU情報が含まれる | E-04 (行174-176) | ○ |
| C-08 | System InfoにMemory情報が含まれる | E-04 (行177-182) | ○ |
| C-09 | System InfoにVM判定が含まれる | E-04 (行183) | ○ |
| C-10 | System InfoにInitial Startupフラグが含まれる | E-04 (行184) | ○ |
| C-11 | System Infoにウィンドウ数が含まれる | E-04 (行185) | ○ |
| C-12 | System InfoにScreen Reader状態が含まれる | E-04 (行186) | ○ |
| C-13 | System InfoにEmpty Workspaceフラグが含まれる | E-04 (行187) | ○ |
| C-14 | Performance Marksテーブルに主要起動フェーズが含まれる | E-05 (行196-223) | ○ |
| C-15 | Extension Activation Statsに7列のテーブルが含まれる | E-06 (行249-251) | ○ |
| C-16 | 拡張機能はEager優先でソートされる | E-06 (行239-246) | ○ |
| C-17 | Terminal Statsはcode/terminal/で始まるマークをフィルタ | E-12 (行155) | ○ |
| C-18 | Workbench ContributionsにStarting/Ready Phase情報 | E-08 (行279-280) | ○ |
| C-19 | Raw Perf Marksはプロセスごとにセクション分け | E-09 (行294-295) | ○ |
| C-20 | Raw Perf Marksはコードブロック形式 | E-09 (行296, 306) | ○ |
| C-21 | Resource Timing Statsはperformance APIから取得 | E-10 (行311-313) | ○ |
| C-22 | メモリ(System)はGB単位で表示 | E-04 (行178) ByteSize.GB使用 | ○ |
| C-23 | メモリ(Process)はMB単位で表示 | E-04 (行181) ByteSize.KB使用 | ○ |
| C-24 | Deltaは前マークとの差分 | E-07 (行264) | ○ |
| C-25 | Totalは累計時間 | E-07 (行265) | ○ |
| C-26 | 初期表示は"Loading..." | E-03 (行124) | ○ |
| C-27 | 4つのサービス準備完了を待つ | E-12 (行139-145) | ○ |
| C-28 | 目標出力時間は1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（目標出力時間）は実装コードに明示的な定義がない
  - 候補：パフォーマンステスト仕様書 / 非機能要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - System Info項目の記述（E-04に基づく）
- 0: 低リスク - Performance Marks構造の記述（E-05に基づく）
- 0: 低リスク - テーブル形式の記述（E-06, E-07に基づく）
- 1: 中リスク - パフォーマンス要件（推測に基づく記述）

## 6) レビュアーチェックリスト（最小）
- [ ] System Info項目が_addSummary()と一致しているか
- [ ] Performance Marks項目が_addSummaryTable()と一致しているか
- [ ] Extension Activation Statsのカラム数・内容が正しいか
- [ ] メモリ単位変換の計算式が正しいか（GB, MB変換）
- [ ] 各セクションの出力条件が実装と一致しているか
